/*
 +----------------------------------------------------------------------+
 | This file is part of the Ayyi project. https://www.ayyi.org          |
 | copyright (C) 2025-2025 Tim Orford <tim@orford.org>                  |
 +----------------------------------------------------------------------+
 | This program is free software; you can redistribute it and/or modify |
 | it under the terms of the GNU General Public License version 3       |
 | as published by the Free Software Foundation.                        |
 +----------------------------------------------------------------------+
 |
 */

#include "config.h"
#include "agl/observable.h"
#include "agl/text/text_buffer.h"
#include "observable.h"

void
test_add_closure ()
{
	// not possible to test it directly, but valgrind confirms all memory is freed.

	START_TEST;

	static bool callback_was_called = false;

	void callback (AGlObservable* o, AGlVal zoom, gpointer _view)
	{
		callback_was_called = true;
	}

	GObject* g = G_OBJECT(agl_text_buffer_new());
	AGlObservable* observable = agl_observable_new();
	agl_obserable_add_closure (observable, g, callback, g_malloc(4));

	assert(callback_was_called, "callback_was_called");
	assert(g->ref_count == 1, "ref count");

	g_object_unref(g);

	callback_was_called = false;
	agl_observable_set_int(observable, 1);
	assert(callback_was_called, "callback is called after closure data freed");

	agl_observable_free(observable);

	FINISH_TEST;
}
