/*
 +----------------------------------------------------------------------+
 | This file is part of the Ayyi project. https://www.ayyi.org          |
 | copyright (C) 2018-2025 Tim Orford <tim@orford.org>                  |
 +----------------------------------------------------------------------+
 | This program is free software; you can redistribute it and/or modify |
 | it under the terms of the GNU General Public License version 3       |
 | as published by the Free Software Foundation.                        |
 +----------------------------------------------------------------------+
 |                                                                      |
 | Transition Observable                                                |
 | ---------------------                                                |
 | AGlTransitionObservable is a subclass of AGlObservable that when     |
 | the value is changed, will emit a series of events that smoothly     |
 | transition to the new value.                                         |
 |                                                                      |
 | To make an animated change, call `transition_observable_set_int`,    |
 | or call `observable_set_int` to make an immediate change.            |
 |                                                                      |
 +----------------------------------------------------------------------+
 |
 */

#pragma once

#include "agl/observable.h"
#include "transition/transition.h"

typedef struct {
	AGlObservable observable;
	WfAnimatable  animatable;
	WfAnimation*  animation;
} AGlTransitionObservable;

AGlTransitionObservable* transition_observable_new     ();
bool                     transition_observable_set_int (AGlTransitionObservable*, int value);
