/*
 +----------------------------------------------------------------------+
 | This file is part of the Ayyi project. https://www.ayyi.org          |
 | copyright (C) 2022-2025 Tim Orford <tim@orford.org>                  |
 +----------------------------------------------------------------------+
 | This program is free software; you can redistribute it and/or modify |
 | it under the terms of the GNU General Public License version 3       |
 | as published by the Free Software Foundation.                        |
 +----------------------------------------------------------------------+
 |
 */

#include "config.h"
#undef USE_GTK
#include "split.h"

static void agl_split_layout (AGlBehaviour*, AGlActor*);

static AGlBehaviourClass klass = {
	.new = agl_split,
	.layout = agl_split_layout
};


AGlBehaviourClass*
agl_split_get_class ()
{
	return &klass;
}


AGlBehaviour*
agl_split ()
{
	return AGL_NEW(AGlBehaviour,
		.klass = &klass,
	);
}


static void
agl_split_layout (AGlBehaviour* behaviour, AGlActor* actor)
{
	int n_children = g_list_length(actor->children);
	float y = 0.;
	float dy = agl_actor__height(actor) / n_children;
	float width = MAX(agl_actor__width(actor), agl_actor__scrollable_width(actor));

	for (GList* l = actor->children; l; l = l->next) {
		AGlActor* child = l->data;
		child->region = (AGlfRegion){
			0.,
			y,
			width,
			y + dy,
		};
		y += dy;
	}
}

