/*
 +----------------------------------------------------------------------+
 | This file is part of the Ayyi project. https://www.ayyi.org          |
 | copyright (C) 2025-2025 Tim Orford <tim@orford.org>                  |
 +----------------------------------------------------------------------+
 | This program is free software; you can redistribute it and/or modify |
 | it under the terms of the GNU General Public License version 3       |
 | as published by the Free Software Foundation.                        |
 +----------------------------------------------------------------------+
 |
 */

#include "config.h"
#undef USE_GTK
#include "debug/debug.h"
#include "keytrap.h"

static bool keytrap_behaviour_handle_event (AGlBehaviour*, AGlActor*, GdkEvent*);

static AGlBehaviourClass klass = {
	.new = keytrap_behaviour,
	.event = keytrap_behaviour_handle_event,
};


AGlBehaviourClass*
keytrap_get_class ()
{
	return &klass;
}


AGlBehaviour*
keytrap_behaviour ()
{
	KeyTrapBehaviour* a = AGL_NEW(KeyTrapBehaviour,
		.behaviour = {
			.klass = &klass,
		},
	);

	return (AGlBehaviour*)a;
}


static bool
keytrap_behaviour_handle_event (AGlBehaviour* behaviour, AGlActor* actor, GdkEvent* event)
{
	bool keytrap_try_children (AGlActor* actor, GdkEvent* event)
	{
		for (GList* l=actor->children;l;l=l->next) {
			AGlActor* child = l->data;

			behaviour_foreach(child)
				if (behaviour->klass->event) {
					if (agl_behaviour_event(behaviour, child, event)) {
						return AGL_HANDLED;
					}
				}
			}

			//if (child->on_event && (handled = child->on_event(child, event, (AGliPt){0,})))
			if (child->on_event && child->on_event(child, event, (AGliPt){0,}))
				return AGL_HANDLED;

			if (keytrap_try_children(child, event))
				return AGL_HANDLED;
		}

		return AGL_NOT_HANDLED;
	}

	switch(event->type){
		case GDK_KEY_PRESS:
			return keytrap_try_children (actor, event);
		default:
			break;
	}

	return AGL_NOT_HANDLED;
}
