/*
 +----------------------------------------------------------------------+
 | This file is part of the Ayyi project. https://www.ayyi.org          |
 | copyright (C) 2019-2025 Tim Orford <tim@orford.org>                  |
 +----------------------------------------------------------------------+
 | This program is free software; you can redistribute it and/or modify |
 | it under the terms of the GNU General Public License version 3       |
 | as published by the Free Software Foundation.                        |
 +----------------------------------------------------------------------+
 |
 */

#include "config.h"
#undef USE_GTK
#include "fullsize.h"

static void fullsize_layout (AGlBehaviour*, AGlActor*);

static AGlBehaviourClass klass = {
	.new = fullsize,
	.layout = fullsize_layout
};


AGlBehaviourClass*
fullsize_get_class ()
{
	return &klass;
}


AGlBehaviour*
fullsize ()
{
	FullsizeBehaviour* a = AGL_NEW(FullsizeBehaviour,
		.behaviour = {
			.klass = &klass,
		},
	);

	return (AGlBehaviour*)a;
}


static void
fullsize_layout (AGlBehaviour* behaviour, AGlActor* actor)
{
	FullsizeBehaviour* fullsize = (FullsizeBehaviour*)behaviour;

	if (actor->parent) {
		actor->region = (AGlfRegion){
			.x1 = actor->parent->region.x1 + fullsize->border.x,
			.y1 = actor->parent->region.y1 + fullsize->border.y,
			.x2 = actor->parent->region.x2 - fullsize->border.x,
			.y2 = actor->parent->region.y2 - fullsize->border.y,
		};
	}
}

