/*
 +----------------------------------------------------------------------+
 | This file is part of the Ayyi project. https://www.ayyi.org          |
 | copyright (C) 2019-2025 Tim Orford <tim@orford.org>                  |
 +----------------------------------------------------------------------+
 | This program is free software; you can redistribute it and/or modify |
 | it under the terms of the GNU General Public License version 3       |
 | as published by the Free Software Foundation.                        |
 +----------------------------------------------------------------------+
 |                                                                      |
 | FollowBehaviour                                                      |
 | Allows the layout and scroll position of an actor to mirror another  |
 |                                                                      |
 +----------------------------------------------------------------------+
 |
 */

#include "config.h"
#undef USE_GTK
#include "agl/behaviours/scrollable_h.h"
#include "follow.h"

#define ORIENTATION_HORIZONTAL

static void follow_init   (AGlBehaviour*, AGlActor*);
static void follow_layout (AGlBehaviour*, AGlActor*);

static AGlBehaviourClass klass = {
	.new = follow,
	.init = follow_init,
	.layout = follow_layout
};


AGlBehaviourClass*
follow_get_class ()
{
	return &klass;
}


AGlBehaviour*
follow ()
{
	FollowBehaviour* a = AGL_NEW(FollowBehaviour,
		.behaviour = {
			.klass = &klass,
		},
	);

	return (AGlBehaviour*)a;
}


static void
follow_init (AGlBehaviour* behaviour, AGlActor* actor)
{
	FollowBehaviour* follow = (FollowBehaviour*)behaviour;

	if (follow->to_follow) {
		AGlBehaviour* scrollable = agl_actor__find_behaviour(follow->to_follow, scrollable_h_get_class());
		g_return_if_fail(scrollable);

		void follow_on_scroll (AGlObservable* o, AGlVal value, gpointer _actor)
		{
			AGlActor* actor = _actor;
			AGlBehaviour* f = agl_actor__find_behaviour(actor, follow_get_class());
			FollowBehaviour* follow = (FollowBehaviour*)f;

#ifdef ORIENTATION_HORIZONTAL
			actor->scrollable.x1 = follow->to_follow->scrollable.x1;
			actor->scrollable.x2 = follow->to_follow->scrollable.x2;
#else
			actor->scrollable = follow->to_follow->scrollable;
#endif
		}
		agl_observable_subscribe_with_state((AGlObservable*)((HScrollableBehaviour*)scrollable)->scroll, follow_on_scroll, actor);
	}
}


static void
follow_layout (AGlBehaviour* behaviour, AGlActor* actor)
{
	FollowBehaviour* follow = (FollowBehaviour*)behaviour;

	if (follow->to_follow) {
#ifdef ORIENTATION_HORIZONTAL
		AGlActor* src = follow->to_follow;

		actor->region.x1 = src->region.x1;
		actor->region.x2 = src->region.x2;
		actor->scrollable.x1 = src->scrollable.x1;
		actor->scrollable.x2 = src->scrollable.x2;
#else
		actor->region = follow->to_follow->region;
		actor->scrollable = follow->to_follow->scrollable;
#endif
	}
}
