#define NO_PLUGIN "No plugin"

#include <model_plugin.h>

enum {
  PLUGIN_TYPE_VST,
  PLUGIN_TYPE_DSSI
};

struct _plugin_window
{
  GtkTreeStore* treestore;
  GtkWidget*    vbox;
};

void       plugins_init();
void       plugins_free();
void       plugin_on_combobox_change(GtkComboBox*, gpointer user_data);
//void       plugin_change_async(Channel*, int plugin_slot, const char* plugin_name);
//void       plugin_changed_cb(AyyiAction*);
gboolean   pluginbox_on_activate(GtkComboBox*, gpointer data);

void       vst_init();
void       vst_get_info();
//void       vst_plugin_add    (int shm_slot, plugin_shared*);

gboolean   plugin_name_valid (const char* plugin_name);

GdkPixbuf* plugin_get_icon   (FSTInfo*);
plug*      plugin_get_by_name(const char*);

GtkWidget* plugin_window_new ();
void       plugin_window_free();

void       statusbar_print(const char* fmt, ...);
int        vst_discover(char* path, char* file);
int        vst_discover_from_path(char* path);

#ifdef __window_c__

enum
{
  COL_ICON = 0,
  COL_NAME,
  COL_CATEGORY,
  COL_N_IN,
  COL_N_OUT,
  COL_IDX,
  COL_DIR,
  NUM_COLS
};

static GtkTreeModel* plugins_create_model();
static void          plugins_load_icons();


#endif
