#include "string.h"
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#include "ayyi_utils.h"
#include "support.h"


void
filename_remove_extension(const char* filename, char* truncated)
{
  g_return_if_fail(filename);
  g_return_if_fail(truncated);

  strcpy(truncated, filename);

  char* dot = strrchr(truncated, '.');
  if(dot) *dot = '\0';
}


gint
filelist_read(const gchar* path, GList** files, GList** dirs)
{
	// get a list of files and subdirs within $path.
	// -each file in the returned list must be freed with g_free().

	DIR *dp;
	struct dirent *dir;
	struct stat ent_sbuf;
	gchar *pathl;
	GList *dlist;
	GList *flist;

	dlist = NULL;
	flist = NULL;

	pathl = path_from_utf8(path);
	if (!pathl || (dp = opendir(pathl)) == NULL){
		g_free(pathl);
		if (files) *files = NULL;
		if (dirs) *dirs = NULL;
		return FALSE;
	}

	// root dir fix
	if (pathl[0] == '/' && pathl[1] == '\0') {
		g_free(pathl);
		pathl = g_strdup("");
	}

	while ((dir = readdir(dp)) != NULL){
		gchar* name = dir->d_name;
		if (FALSE || !is_hidden(name))
			{
			gchar* filepath = g_strconcat(pathl, "/", name, NULL);
			if (stat(filepath, &ent_sbuf) >= 0)
				{
				if (S_ISDIR(ent_sbuf.st_mode))
					{
					if ((dirs) &&
					    !(name[0] == '.' && (name[1] == '\0' || (name[1] == '.' && name[2] == '\0')))/* &&
					    strcmp(name, GQVIEW_CACHE_DIR) != 0*/)
						{
						dbg (0, "adding file=%s...", filepath);
						//dlist = g_list_prepend(dlist, file_data_new(filepath, &ent_sbuf)); // gqview uses a struct
						dlist = g_list_prepend(dlist, filepath);
						}
					}
				else
					{
					if ((files)/* && filter_name_exists(name)*/)
						{
						flist = g_list_prepend(flist, filepath);
						}
					}
				}
			//g_free(filepath);
			}
		}

	closedir(dp);

	g_free(pathl);

	if (dirs) *dirs = dlist;
	if (files) *files = flist;

	return TRUE;
}


gint
is_hidden(const gchar* name)
{
	if (name[0] != '.') return FALSE;
	if (name[1] == '\0' || (name[1] == '.' && name[2] == '\0')) return FALSE;
	return TRUE;
}


void
replace(char* string, char* oldpiece, char* newpiece)
{
  //perform a string replacement in-place.
  //@param string must be allocated with 256 chars. Modified string may be longer than the original.

  int str_index, newstr_index, oldpiece_index, end, new_len, old_len, cpy_len;
  char* c;
  static char newstring[256];

  if((c = (char *) strstr(string, oldpiece)) == NULL) return;

  new_len        = strlen(newpiece);
  old_len        = strlen(oldpiece);
  end            = strlen(string)   - old_len;
  oldpiece_index = c - string;

  newstr_index = 0;
  str_index = 0;
  while(str_index <= end && c != NULL){
    //copy characters from the left of matched pattern occurence
    cpy_len = oldpiece_index-str_index;
    strncpy(newstring+newstr_index, string+str_index, cpy_len);
    newstr_index += cpy_len;
    str_index    += cpy_len;

    //copy replacement characters instead of matched pattern
    strcpy(newstring+newstr_index, newpiece);
    newstr_index += new_len;
    str_index    += old_len;

    //check for another pattern match
    if((c = (char *) strstr(string+str_index, oldpiece)) != NULL) oldpiece_index = c - string;
  }

  //copy remaining characters from the right of last matched pattern
  strcpy(newstring+newstr_index, string+str_index);
  strcpy(string, newstring);
}


