#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkevents.h>
#include <X11/Xlib.h>

#define GDK_PIXMAP_SCREEN(pix)        (GDK_DRAWABLE_IMPL_X11 (((GdkPixmapObject *)pix)->impl)->screen)
#define GDK_PIXMAP_DISPLAY(pix)       (GDK_SCREEN_X11 (GDK_PIXMAP_SCREEN (pix))->display)
#define GDK_PIXMAP_XROOTWIN(pix)      (GDK_SCREEN_X11 (GDK_PIXMAP_SCREEN (pix))->xroot_window)
#define GDK_DRAWABLE_DISPLAY(win)     (GDK_IS_WINDOW (win) ? GDK_WINDOW_DISPLAY (win) : GDK_PIXMAP_DISPLAY (win))
#define GDK_DRAWABLE_SCREEN(win)      (GDK_IS_WINDOW (win) ? GDK_WINDOW_SCREEN (win) : GDK_PIXMAP_SCREEN (win))
#define GDK_DRAWABLE_XROOTWIN(win)    (GDK_IS_WINDOW (win) ? GDK_WINDOW_XROOTWIN (win) : GDK_PIXMAP_XROOTWIN (win))
#define GDK_SCREEN_DISPLAY(screen)    (GDK_SCREEN_X11 (screen)->display)
#define GDK_SCREEN_XROOTWIN(screen)   (GDK_SCREEN_X11 (screen)->xroot_window)
#define GDK_WINDOW_SCREEN(win)        (GDK_DRAWABLE_IMPL_X11 (((GdkWindowObject *)win)->impl)->screen)
#define GDK_WINDOW_DISPLAY(win)       (GDK_SCREEN_X11 (GDK_WINDOW_SCREEN (win))->display)
#define GDK_WINDOW_XROOTWIN(win)      (GDK_SCREEN_X11 (GDK_WINDOW_SCREEN (win))->xroot_window)
#define GDK_GC_DISPLAY(gc)            (GDK_SCREEN_DISPLAY (GDK_GC_X11(gc)->screen))

#define STOP FALSE

#include "jackvst.h"
#include "ayyi_utils.h"

static	GtkWidget* window;
static	GtkWidget* socket;
static	GtkWidget* vpacker;
static	GtkWidget* hpacker;
static	GtkWidget* bypass_button;
static	GtkWidget* remove_button;
static	GtkWidget* mute_button;
static	GtkWidget* event_box;

extern lash_client_t * lash_client;
extern gboolean        lash_is_enabled;
extern void easyfst_quit();

static void auto_connect_outputs (JackVST*, const char** ports);
static void alsa_autoconnect     (JackVST*);
static void alsa_list_each_subs  (snd_seq_t*, snd_seq_query_subscribe_t*, int type, const char* msg);


static void
bypass_handler (GtkToggleButton *but, gboolean ptr)
{
	JackVST* jvst = (JackVST*) ptr;
	
	jvst->bypassed = gtk_toggle_button_get_active (but);
}

static void
mute_handler (GtkToggleButton *but, gboolean ptr)
{
	JackVST* jvst = (JackVST*) ptr;
	jvst->muted = gtk_toggle_button_get_active (but);
}

static void
remove_handler (GtkToggleButton *but, gboolean ptr)
{
	JackVST* jvst = (JackVST*) ptr;
	
	jack_deactivate (jvst->client);
	fst_destroy_editor (jvst->fst);
}

static gboolean
configure_handler (GtkWidget* widget, GdkEventConfigure* ev, GtkSocket *socket)
{
	XEvent event;
	gint x, y;

	g_return_if_fail (socket->plug_window != NULL);
	event.xconfigure.type = ConfigureNotify;

	event.xconfigure.event = GDK_WINDOW_XWINDOW (socket->plug_window);
	event.xconfigure.window = GDK_WINDOW_XWINDOW (socket->plug_window);

	/* The ICCCM says that synthetic events should have root relative
	 * coordinates. We still aren't really ICCCM compliant, since
	 * we don't send events when the real toplevel is moved.
	 */
	gdk_error_trap_push ();
	gdk_window_get_origin (socket->plug_window, &x, &y);
	gdk_error_trap_pop ();

	event.xconfigure.x = x;
	event.xconfigure.y = y;
	event.xconfigure.width = GTK_WIDGET(socket)->allocation.width;
	event.xconfigure.height = GTK_WIDGET(socket)->allocation.height;

	event.xconfigure.border_width = 0;
	event.xconfigure.above = None;
	event.xconfigure.override_redirect = False;

	gdk_error_trap_push ();
	XSendEvent (GDK_WINDOW_XDISPLAY (socket->plug_window),
		    GDK_WINDOW_XWINDOW (socket->plug_window),
		    False, StructureNotifyMask, &event);
	gdk_display_sync (gtk_widget_get_display (GTK_WIDGET (socket)));
	gdk_error_trap_pop ();

	return FALSE;
}

void
forward_key_event (GdkEventKey* ev, GtkSocket* socket, JackVST* jvst)
{
	XKeyEvent event;
	Status status;

	g_return_if_fail (socket->plug_window != NULL);
	
	event.type = (ev->type == GDK_KEY_PRESS ? KeyPress : KeyRelease);
	event.display = GDK_WINDOW_XDISPLAY (socket->plug_window);
	event.window = fst_get_XID (jvst->fst);
	event.time = ev->time;
	event.x = 1;
	event.y = 1;
	event.x_root = 1;
	event.y_root = 1;
	event.state = ev->state;
	event.keycode = ev->hardware_keycode;
	event.same_screen = True;
	
	gdk_error_trap_push ();
	XSendEvent (event.display, event.window, False, 0, (XEvent*) &event);
	gdk_display_sync (gtk_widget_get_display (GTK_WIDGET (socket)));
	gdk_error_trap_pop ();
}

static gboolean
destroy_handler (GtkWidget* widget, GdkEventAny* ev, gpointer ptr)
{
	JackVST* jvst = (JackVST*) ptr;
	fst_destroy_editor (jvst->fst);
	easyfst_quit();
	
	return FALSE;
}

int
focus_handler (GtkWidget* widget, GdkEventFocus* ev, gpointer ptr)
{
	if (ev->in) {
		fst_error ("Socket focus in");
	} else {
		fst_error ("Socket focus out");
	}
		       
	return FALSE;
}

////////////////
// LASH
//


void
save_data( JackVST *jvst )
{
	if(!lash_is_enabled) return;

	int i, bytelen;
	lash_config_t *config;
	void *chunk;

	for( i=0; i<jvst->fst->plugin->numParams; i++ ) {
	    char buf[10];
	    
	    snprintf( buf, 9, "%d", i );

	    config = lash_config_new_with_key( buf );
	    lash_config_set_value_double(config, jvst->fst->plugin->getParameter( jvst->fst->plugin, i ) );
	    lash_send_config(lash_client, config);
	    //lash_config_destroy( config );
	}

	if( jvst->fst->plugin->flags & effFlagsProgramChunks ) {
	    printf( "getting chunk...\n" );
	    bytelen = jvst->fst->plugin->dispatcher( jvst->fst->plugin, effGetChunk, 0, 0, &chunk, 0 );
	    printf( "got tha chunk..\n" );
	    if( bytelen ) {
		if( bytelen < 0 ) {
		    printf( "Chunke len < 0 !!! Not saving chunk.\n" );
		} else {
		    config = lash_config_new_with_key( "bin_chunk" );
		    lash_config_set_value(config, chunk, bytelen );
		    lash_send_config(lash_client, config);
		    //lash_config_destroy( config );
		}


	    }
	}

}

void
restore_data(lash_config_t * config, JackVST *jvst )
{
	if(!lash_is_enabled) return;

	const char *key;

	key = lash_config_get_key(config);
	dbg(0, "key=%s", key);

	if (strcmp(key, "bin_chunk") == 0) {
	    jvst->fst->plugin->dispatcher( jvst->fst->plugin, effSetChunk, 0, lash_config_get_value_size( config ), (void*)lash_config_get_value( config ), 0 );
	    return;
	}

	jvst->fst->plugin->setParameter( jvst->fst->plugin, atoi( key ), lash_config_get_value_double( config ) );

}

static void
auto_connect(JackVST* jvst, const char** ports)
{
	auto_connect_outputs(jvst, ports);
	alsa_autoconnect(jvst);
}

static void
auto_connect_outputs(JackVST* jvst, const char** ports)
{
	//this is a fallback function for the case where lash hasnt handled the connections.

	if(!ports) return;

	jack_port_t*
	get_next_src_port(const char** ports, int* src_idx)
	{
		int p = *src_idx + 1;
		const char* port_name;
		if(!(port_name = ports[p])){
			dbg(3, "out of source ports. total=%i", p);
			p = 0;
			port_name = ports[p];
			*src_idx = -1;
		}
		(*src_idx)++;
		return jack_port_by_name (jvst->client, port_name);
	}

	int src_idx = 0;
	g_return_if_fail(ports[src_idx]);
	jack_port_t* src = jack_port_by_name(jvst->client, ports[src_idx]);
	if(!src) return;

	const char** out_ports = jack_get_ports(jvst->client, NULL, NULL, JackPortIsInput | JackPortIsPhysical);
	int done = 0;
	int i; for(i=0;i<0xff, out_ports[i], done<2;i++){
		jack_port_t* port = jack_port_by_name (jvst->client, out_ports[i]);
		dbg(0, "connecting: %s --> %s", jack_port_name(src), out_ports[i]);
		jack_connect (jvst->client, jack_port_name(src), out_ports[i]);
		done++;

		src = get_next_src_port(ports, &src_idx);
	}
	free(out_ports);
}

#define UNDERLINE printf("--------------------------------------------------------\n");

static snd_seq_addr_t*
get_alsa_keyboard(snd_seq_t* seq)
{
	snd_seq_client_info_t *cinfo;
	snd_seq_port_info_t *pinfo;
	int count;
	int perm = 0;
	gboolean found = false;

	snd_seq_addr_t* client = NULL;

	UNDERLINE;

	snd_seq_client_info_alloca(&cinfo);
	snd_seq_port_info_alloca(&pinfo);
	snd_seq_client_info_set_client(cinfo, -1);
	while (snd_seq_query_next_client(seq, cinfo) >= 0) {
		/* reset query info */
		snd_seq_port_info_set_client(pinfo, snd_seq_client_info_get_client(cinfo));
		snd_seq_port_info_set_port(pinfo, -1);
		count = 0;
		while (snd_seq_query_next_port(seq, pinfo) >= 0) {
			//if (check_permission(pinfo, perm)) {
			gboolean is_user_client = (snd_seq_client_info_get_type(cinfo) == SND_SEQ_USER_CLIENT);

			if (! count) {
				printf("client %d: '%s' [type=%s]\n",
					snd_seq_client_info_get_client(cinfo),
					snd_seq_client_info_get_name(cinfo),
					(is_user_client ? "user" : "kernel"));
			}
			printf("  %3d '%-16s'\n", snd_seq_port_info_get_port(pinfo), snd_seq_port_info_get_name(pinfo));

			//use first kernel client with non zero id:
			if(!found && !is_user_client && snd_seq_client_info_get_client(cinfo)){
				printf("    *** connecting this port...\n");

				client         = g_new0(snd_seq_addr_t, 1);
				client->client = snd_seq_client_info_get_client(cinfo);
				client->port   = 0;

				found = true;
			}

			count++;
			//}
		}
	}
	UNDERLINE;
	return client;
}


static void
alsa_autoconnect(JackVST* jvst)
{
	/*
	struct snd_seq_addr {
		unsigned char   client
		unsigned char   port
	}
	*/
	snd_seq_t* seq = jvst->seq;

	dbg(0, "checking midi connections...");

	snd_seq_client_info_t* client;
	snd_seq_client_info_alloca (&client);
	if(snd_seq_get_client_info(seq, client)){
		easyfst_error("failed to get alsa client info.");
		return;
	}
	int client_id = snd_seq_client_info_get_client(client);
	dbg(0, "client=%i", client_id);

	snd_seq_addr_t dest;
	dest.client   = client_id;
	dest.port     = 0;


#if 0
	snd_seq_addr_t* addr = snd_seq_port_info_get_addr(pinfo);

	snd_seq_query_subscribe_t* subs;
	snd_seq_query_subscribe_alloca(&subs);
	snd_seq_query_subscribe_set_root(subs, addr);
	alsa_list_each_subs(seq, snd_seq_query_subscribe_t* subs, int type, const char* msg);
#endif

	snd_seq_addr_t* src = get_alsa_keyboard(seq);
	if (src) {
		snd_seq_port_subscribe_t* subs;
		snd_seq_port_subscribe_alloca(&subs);
		snd_seq_port_subscribe_set_sender(subs, src);
		snd_seq_port_subscribe_set_dest(subs, &dest);
		snd_seq_port_subscribe_set_queue(subs, 1);
		snd_seq_port_subscribe_set_time_update(subs, 1);
		snd_seq_port_subscribe_set_time_real(subs, 1);
		if (snd_seq_subscribe_port(seq, subs)) {
			easyfst_error("midi connection failed.");
		}

		//how to free the client_info? alloca fns put it on a stack, and dont use malloc.
		//snd_seq_client_info_free(client);

		g_free(src);
	}
}

static void
alsa_list_each_subs(snd_seq_t* seq, snd_seq_query_subscribe_t* subs, int type, const char* msg)
{
	int count = 0;
	snd_seq_query_subscribe_set_type(subs, type);
	snd_seq_query_subscribe_set_index(subs, 0);
	while (snd_seq_query_port_subscribers(seq, subs) >= 0) {
		const snd_seq_addr_t *addr;
		if (count++ == 0)
			printf("\t%s: ", msg);
		else
			printf(", ");
		addr = snd_seq_query_subscribe_get_addr(subs);
		printf("%d:%d", addr->client, addr->port);
		if (snd_seq_query_subscribe_get_exclusive(subs))
			printf("[ex]");
		if (snd_seq_query_subscribe_get_time_update(subs))
			printf("[%s:%d]",
			       (snd_seq_query_subscribe_get_time_real(subs) ? "real" : "tick"),
			       snd_seq_query_subscribe_get_queue(subs));
		snd_seq_query_subscribe_set_index(subs, snd_seq_query_subscribe_get_index(subs) + 1);
	}
	if (count > 0)
		printf("\n");
}

gboolean
post_instantiate_sanity_check(gpointer user_data)
{
	PF;
	JackVST* jvst = (JackVST*)user_data;

	//are we connected to system audio output?

	const char** ports = jack_get_ports(jvst->client, NULL, NULL, JackPortIsOutput);
	gboolean connected = false;
	char** ports_to_connect = g_malloc0(sizeof(char*) * 16);
	int o = 0;
	int i; for(i=0;i<0xff, ports[i];i++){
		jack_port_t* port = jack_port_by_name (jvst->client, ports[i]);
		if(port && jack_port_is_mine (jvst->client, port)){
			dbg(3, "port=%s", ports[i]);
			ports_to_connect[o++] = (char*)ports[i];
			const char** connections = jack_port_get_connections(port);
			if(connections){
				int c; for(c=0;c<0xff, connections[c];c++){
				}
				dbg(3, "  is connected!");
				connected = true;
				free(connections);
			}
			else{
				dbg(3, "  not connected");
			}
		}
	}
	if(!connected) auto_connect(jvst, (const char**)ports_to_connect);
	free(ports);
	g_free(ports_to_connect);

	return STOP;
}

void
vst_window_new(JackVST* jvst)
{
	// create a GtkWindow containing a GtkSocket...
	//
	// notice the order of the functions.
	// you can only add an id to an anchored widget.
	
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW(window), jvst->handle->name);

	vpacker = gtk_vbox_new (FALSE, 7);
	hpacker = gtk_hbox_new (FALSE, 7);
	bypass_button = gtk_toggle_button_new_with_label ("bypass");
	mute_button = gtk_toggle_button_new_with_label ("mute");
	remove_button = gtk_toggle_button_new_with_label ("remove");

	gtk_signal_connect (GTK_OBJECT(bypass_button), "toggled",
			    GTK_SIGNAL_FUNC(bypass_handler),
			    jvst);

	gtk_signal_connect (GTK_OBJECT(mute_button), "toggled",
			    GTK_SIGNAL_FUNC(mute_handler),
			    jvst);

	gtk_signal_connect (GTK_OBJECT(remove_button), "toggled",
			    GTK_SIGNAL_FUNC(remove_handler),
			    jvst);

	gtk_container_set_border_width (GTK_CONTAINER(hpacker), 3);

	gtk_signal_connect (GTK_OBJECT(window), "delete_event",
			    GTK_SIGNAL_FUNC(destroy_handler),
			    jvst);

	socket = gtk_socket_new ();
	GTK_WIDGET_SET_FLAGS(socket, GTK_CAN_FOCUS);
	
	gtk_box_pack_end   (GTK_BOX(hpacker), bypass_button, FALSE, FALSE, 0);
	gtk_box_pack_end   (GTK_BOX(hpacker), mute_button, FALSE, FALSE, 0);
	// gtk_box_pack_end   (GTK_BOX(hpacker), remove_button, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vpacker), hpacker, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vpacker), socket, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (window), vpacker);

	// normally every socket should register it self like this.
	gtk_signal_connect (GTK_OBJECT(window), "configure_event",
			    GTK_SIGNAL_FUNC(configure_handler),
			    socket);

	//gtk_socket_add_id (GTK_SOCKET (socket), fst_get_XID (jvst->fst));

	// but you can show() a GtkSocket only with an id set.
	
 	//gtk_widget_show_all (window);
	//gtk_window_set_focus (GTK_WINDOW(window), socket);

	g_timeout_add(2000, (gpointer)post_instantiate_sanity_check, jvst);
}

void
gui_init (int *argc, char **argv[])
{
	gtk_init (argc, argv);
}
