
#define dbg(A, B, ...) debug_printf(__func__, A, B, ##__VA_ARGS__)
#define gerr(A, ...) g_critical("%s(): "A, __func__, ##__VA_ARGS__)
#define gwarn(A, ...) g_warning("%s(): "A, __func__, ##__VA_ARGS__);
#define PF printf("%s()...\n", __func__);
#if 0
#define PF_DONE printf("%s(): done.\n", __func__);
#define IS_PTR(A) ((guint)A > 1024)
#define P_GERR if(error){ gerr("%s\n", error->message); g_error_free(error); error = NULL; }
#define GERR_INFO if(error){ printf("%s\n", error->message); g_error_free(error); error = NULL; }
#define GERR_WARN if(error){ gwarn("%s", error->message); g_error_free(error); error = NULL; }
#define UNDERLINE printf("-----------------------------------------------------\n")

void        debug_printf   (const char* func, int level, const char *format, ...);
void        errprintf      (char *fmt, ...);
void        errprintf2     (const char* func, char *format, ...);
void        errprintf3     (const char* func, char *format, ...);
void        warnprintf2    (const char* func, char *format, ...);
void        warn_gerror    (const char* msg, GError** error);
#endif

gchar*      path_from_utf8 (const gchar* utf8);

//GList*      get_dirlist    (const char*);

//int         get_terminal_width();

#ifdef __ayyi_utils_c__
char ayyi_err [32] = "\x1b[1;31merror!\x1b[0;39m";
char ayyi_warn[32] = "\x1b[1;33mwarning:\x1b[0;39m";
#else
extern char ayyi_err [32];
extern char ayyi_warn[32];
#endif
#if 0
#ifdef __ayyi_utils_c__
char white [16] = "\x1b[0;39m";
char bold  [16] = "\x1b[1;39m";
char yellow[16] = "\x1b[1;33m";
char red   [16] = "\x1b[1;31m";
char green [16] = "\x1b[1;32m";
char go_rhs[32] = "\x1b[A\x1b[50C"; //go up one line, then goto column 60
char ok    [32] = " [ \x1b[1;32mok\x1b[0;39m ]";
char fail  [32] = " [\x1b[1;31mFAIL\x1b[0;39m]";
#else
extern char white [16];
extern char bold  [16];
extern char yellow[16];
extern char red   [16];
extern char green [16];
extern char go_rhs[32];
extern char ok    [];
extern char fail  [];
#endif
#endif //0

#define true  1
#define false 0
